<?php

class Wallet {
    private $wallet;
    private $key;
    private $url;
    private $date;
 
    public function __construct($wallet, $key) {
        $this->wallet = $wallet;
        $this->key = $key;
        $this->url = 'https://edge.qiwi.com';
        $this->date = new DateTime(date('Y-m-d'));
    }
    
    private function execute($method, array $parameters = []) {
        $headers = [
            'Accept: application/json; charset=utf-8',
            'Authorization: Bearer ' . $this->key,
            'Host: edge.qiwi.com',
        ];
        
        $curl = curl_init($this->url . $method . http_build_query($parameters));
        
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($curl);
        $received = json_decode($response, true);
        
        curl_close($curl);
        return $received['data'];
    }
    
    public function getPayments() {
        $parameters = [
            'rows' => 50,
            'operation' => 'IN',
            'sources' => 'sources[0]',
            'startDate' => $this->date->modify('-1 day')->format('c'),
            'endDate' => $this->date->modify('+2 days')->format('c'),
        ];
        
        return $this->execute('/payment-history/v2/persons/' . $this->wallet . '/payments?', $parameters);
    }
}